#!/bin/python
#

class Actor:
    def __init__(self, name, variantscale, original_height, original_radius):
        self.name            = name
        self.variantscale    = variantscale
        self.original_height = original_height
        self.original_radius = original_radius

class VariantScale:
    def __init__(self, new_scale, old_scale):
        self.new_scale = new_scale
        self.old_scale = old_scale
        
    def Ratio(self):
        return self.new_scale / self.old_scale

chs_dragon_ogre                   = Actor("chs_dragon_ogre",                   VariantScale(1.25, 1.00), original_height = 3.10, original_radius = 1.75)
chs_dragon_ogre_shaggoth          = Actor("chs_dragon_ogre_shaggoth",          VariantScale(2.00, 1.75), original_height = 6.40, original_radius = 3.90)
chs_dragon_ogre_shaggoth_boss     = Actor("chs_dragon_ogre_shaggoth_boss",     VariantScale(2.50, 2.25), original_height = 9.20, original_radius = 5.50)
wh_chs_ch_kholek_suneater         = Actor("wh_chs_ch_kholek_suneater",         VariantScale(2.50, 2.00), original_height = 6.75, original_radius = 4.00)
wh_dlc04_vmp_dire_wolves_direpack = Actor("wh_dlc04_vmp_dire_wolves_direpack", VariantScale(1.6, 1.15),  original_height = 1.2, original_radius = 0.9)
wh_vmp_dire_wolves                = Actor("wh_vmp_dire_wolves",                VariantScale(1.6, 1.00), original_height = 1.2, original_radius = 0.9)
wh_vmp_crypt_horror_huge          = Actor("wh_vmp_crypt_horror (HUGE)",        VariantScale(2.5, 1.5), original_height = 3.6, original_radius = 1.2)
wh_vmp_vargheist                  = Actor("wh_vmp_vargheist",                  VariantScale(1.1, 1.00), original_height = 3.0, original_radius = 1.4)
wh_vmp_vargheist_devil            = Actor("wh_vmp_vargheist_devil",            VariantScale(1.2, 1.00), original_height = 3.0, original_radius = 1.4)

actorlist = [chs_dragon_ogre, chs_dragon_ogre_shaggoth, chs_dragon_ogre_shaggoth_boss, wh_chs_ch_kholek_suneater, wh_dlc04_vmp_dire_wolves_direpack, wh_vmp_dire_wolves, wh_vmp_crypt_horror_huge, wh_vmp_vargheist, wh_vmp_vargheist_devil]
for actor in actorlist:
    height_scaled = actor.original_height * actor.variantscale.Ratio()
    radius_scaled = actor.original_radius * actor.variantscale.Ratio()

    print(f"Actor: {actor.name}")
    print(f"\tHeight: {height_scaled:.2f} ({actor.original_height:.2f})")
    print(f"\tRadius: {radius_scaled:.2f} ({actor.original_radius:.2f})")
    print()
